#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"
// LIST OF PRECOMPUTED SYSTEM PARAMETERS

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_Q             "11532304439951903318047260070672268613130768031212132639712137620"
#define KAZ_DS_SP_q             "2840556527694295864950860759784740510458069976738706234986729593207"

#define KAZ_DS_SP_G0            "23102151283542472555351033031857407110549489214984451103786304558150674606117088000"
#define KAZ_DS_SP_LG0         	274

#define KAZ_DS_SP_G1           	"399620650696124709852000"
#define KAZ_DS_SP_LG1         	79

#define KAZ_DS_SP_qQ			"32758162656263289822165160082704286295984704353673644459843294584139742401444681348237525839805407482025757064066007727363001147340"

#define KAZ_DS_SP_G1Q			"4608547004319387654881652854271902912074234058530475066429443362275603653525193832240000"
#define KAZ_DS_SP_G1qQ			"13090838276305428924247929917578047388383153565181983797742543219763224257069925679653256939665276658294888270249959692327414309037315665772000601593680000"

#define KAZ_DS_SP_PHIG1        	"60408037934094090240000"
#define KAZ_DS_SP_PHIPHIG1     	"11456568251237007360000"
#define KAZ_DS_SP_PHIQ         	"1251434900161857001704369748558994349944756643204956160000000000"
#define KAZ_DS_SP_PHIqQ			"3554771574639222339069568200522429346291071123851611090794232823233857364488038302147974718854109146210993915839863848960000000000"

#define KAZ_DS_SP_RAN			4
#define KAZ_DS_SP_A				"324324000"

#define KAZ_DS_SP_J         	256
#define KAZ_DS_SP_K         	256
#define KAZ_DS_SP_RHO       	"198021528630713657130647755098628422784347134255355410420633410582878292457267"
#define KAZ_DS_SP_G1RHO 		"79133492123247080788931646239320683796403476070676429894067272105048512318726473299394190483894484000"
#define KAZ_DS_SP_LG1RHO		336
#define KAZ_DS_SP_G1QRHO 		"912591522561821278596773661560381738487461196149374758031226045379636805516124374209533548227239075617507685978157416122232368826810589739482354141490542166888080000"
#define KAZ_DS_SP_G1qQRHO		"2592267806531457714429433492040209571481423408663539591272600175454852168743179040721147413119890879277149563138414212135077674649704847604432326896895145786034397225901388681187070510067902252928183759793847469262075483497272560000"
#define KAZ_DS_SP_PHIG1RHO		"11962092013291449570594069903360588033560122759492301165447160574650084840217432160356538347683840000"
#define KAZ_DS_SP_PHIPHIG1RHO	"1134323578986027073739504344459924880821604430088910642679765319339580831866513781010934026731520000"

#define KAZ_DS_SKBYTES    		97
#define KAZ_DS_V1BYTES      	42
#define KAZ_DS_V2BYTES      	55
#define KAZ_DS_S1BYTES       	97 // S1=97 bytes
#define KAZ_DS_S2BYTES       	8 // S2=8 bytes

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
							   const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
